<?php
/**
 * Ajax Add to Cart Feature Settings
 *
 * @package BebanStore
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'ajax_add_to_cart',
    'name' => __('افزودن به سبد خرید با Ajax', 'bebanstore'),
    'description' => __('افزودن محصول به سبد خرید بدون بارگذاری مجدد صفحه', 'bebanstore'),
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تنظیمات رفتاری
        'behavior_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات رفتاری', 'bebanstore'),
            'description' => __('نوع انیمیشن و پیام‌های نمایشی را تنظیم کنید', 'bebanstore')
        ),
        'animation_type' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => __('نوع انیمیشن دکمه', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('نوع انیمیشن نمایشی هنگام کلیک روی دکمه افزودن به سبد خرید', 'bebanstore')
                )
            ),
            'default' => 'none',
            'options' => array(
                'none' => __('بدون انیمیشن', 'bebanstore'),
                'spinner' => __('اسپینر', 'bebanstore'),
                'text' => __('متن', 'bebanstore'),
                'dots' => __('نقطه‌ها', 'bebanstore')
            )
        ),
        'success_message_type' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => __('نوع پیام موفقیت', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('نوع پیامی که پس از افزودن موفقیت‌آمیز محصول به سبد خرید به کاربر نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'no_message',
            'options' => array(
                'no_message' => __('بدون پیام', 'bebanstore'),
                'cart' => __('برو به سبد خرید', 'bebanstore'),
                'simple' => __('پیام ساده', 'bebanstore')
            )
        ),
        
        // ========== تب استایل ==========
        
        // گروه رنگ‌های لودر
        'loader_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌های لودر', 'bebanstore'),
            'description' => __('رنگ‌های انیمیشن بارگذاری را تنظیم کنید', 'bebanstore')
        ),
        'loader_overlay_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ overlay لودر', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه انیمیشن لودر هنگام افزودن به سبد', 'bebanstore')
                )
            ),
            'default' => '#EF4056',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'loader_animation_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ انیمیشن لودر', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ انیمیشن بارگذاری هنگام افزودن به سبد', 'bebanstore')
                )
            ),
            'default' => '#ffffff',
            'sanitize_callback' => 'sanitize_text_field'
        )
    )
); 