<?php
/**
 * تنظیمات ویژگی شمارنده معکوس
 */
return array(
    'id' => 'countdown',
    'name' => 'شمارنده معکوس',
    'description' => 'نمایش شمارنده معکوس برای محصولات با زمان محدود یا تخفیف‌های موقت',
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تنظیمات محصولات متغیر
        'variable_products_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات محصولات متغیر', 'bebanstore'),
            'description' => __('نحوه انتخاب زمان شمارنده معکوس برای محصولات متغیر را تنظیم کنید', 'bebanstore')
        ),
        'variable_countdown_mode' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => __('حالت انتخاب زمان', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('نحوه انتخاب زمان شمارنده معکوس برای محصولات متغیر را تعیین کنید', 'bebanstore')
                )
            ),
            'default' => 'default_variation',
            'options' => array(
                'default_variation' => __('متغیرهای پیشفرض', 'bebanstore'),
                'shortest_time' => __('کمترین زمان', 'bebanstore'),
                'longest_time' => __('طولانی‌ترین زمان', 'bebanstore')
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        
        
        // گروه تنظیمات سبک نمایش
        'display_style_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('سبک نمایش', 'bebanstore'),
            'description' => __('انتخاب نحوه نمایش شمارنده معکوس', 'bebanstore')
        ),
        'display_style' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => __('نوع سبک نمایش', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('انتخاب نحوه نمایش شمارنده معکوس: کلاسیک (بدون برچسب)، کارتی (با برچسب در کادرهای جداگانه)، یا خطی (با برچسب در یک خط)', 'bebanstore')
                )
            ),
            'default' => 'card',
            'options' => array(
                'classic' => __('کلاسیک (بدون برچسب)', 'bebanstore'),
                'card' => __('کارتی (با برچسب)', 'bebanstore'),
                'inline' => __('خطی (با برچسب)', 'bebanstore')
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        
        // ========== تب استایل ==========
        
        // گروه تنظیمات ظاهری
        'appearance_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('تنظیمات ظاهری', 'bebanstore'),
            'description' => __('رنگ و نمایش شمارنده معکوس را تنظیم کنید', 'bebanstore')
        ),
        'countdown_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ شمارنده', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ اعداد شمارنده معکوس', 'bebanstore')
                )
            ),
            'default' => '#000000',
            
        ),
        'number_font_size' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => __('اندازه فونت اعداد', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('اندازه فونت اعداد شمارنده معکوس (پیکسل)', 'bebanstore')
                )
            ),
            'default' => '14',
            'min' => '8',
            'max' => '48',
            'step' => '1'
        ),
        'separator_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ جداکننده', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ جداکننده‌های شمارنده معکوس (دو نقطه)', 'bebanstore')
                )
            ),
            'default' => '#000000',
            'sanitize_callback' => 'sanitize_hex_color'
        ),
        'separator_font_size' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => __('اندازه فونت جداکننده', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('اندازه فونت جداکننده‌های شمارنده معکوس (پیکسل)', 'bebanstore')
                )
            ),
            'default' => '16',
            'min' => '8',
            'max' => '48',
            'step' => '1'
        ),
        'label_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ برچسب‌ها', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ برچسب‌های زمان (روز، ساعت، دقیقه، ثانیه)', 'bebanstore')
                )
            ),
            'default' => '#666666',
            'sanitize_callback' => 'sanitize_hex_color'
        ),
        'label_font_size' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => __('اندازه فونت برچسب‌ها', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('اندازه فونت برچسب‌های زمان (پیکسل)', 'bebanstore')
                )
            ),
            'default' => '12',
            'min' => '8',
            'max' => '24',
            'step' => '1'
        ),
        'box_padding' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => __('فاصله داخلی', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('فاصله داخلی (Padding) آیتم‌های شمارنده در تمام سبک‌ها (پیکسل)', 'bebanstore')
                )
            ),
            'default' => '8',
            'min' => '0',
            'max' => '30',
            'step' => '1'
        ),
        
        // گروه تنظیمات سبک کارتی
        'card_style_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('تنظیمات سبک کارتی', 'bebanstore'),
            'description' => __('تنظیمات اختصاصی برای حالت نمایش کارتی', 'bebanstore'),
            'dependency' => array('display_style', '==', 'card')
        ),
        'card_background_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه کادرها', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه کادرهای شمارنده در حالت کارتی', 'bebanstore')
                )
            ),
            'default' => '#ffffff',
            'sanitize_callback' => 'sanitize_text_field',
            'dependency' => array('display_style', '==', 'card')
        ),
        'card_border_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ حاشیه کادرها', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ حاشیه کادرهای شمارنده در حالت کارتی', 'bebanstore')
                )
            ),
            'default' => '#ededed',
            'sanitize_callback' => 'sanitize_hex_color',
            'dependency' => array('display_style', '==', 'card')
        ),
        'card_border_width' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => __('ضخامت حاشیه کادرها', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('ضخامت حاشیه کادرهای شمارنده در حالت کارتی (پیکسل)', 'bebanstore')
                )
            ),
            'default' => '1',
            'min' => '0',
            'max' => '10',
            'step' => '1',
            'dependency' => array('display_style', '==', 'card')
        ),
        'card_border_radius' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => __('نرمی گوشه‌های کادرها', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('نرمی گوشه‌های کادرهای شمارنده در حالت کارتی (پیکسل)', 'bebanstore')
                )
            ),
            'default' => '8',
            'min' => '0',
            'max' => '30',
            'step' => '1',
            'dependency' => array('display_style', '==', 'card')
        ),
        'card_gap' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => __('فاصله بین کادرها', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('فاصله بین کادرهای شمارنده در حالت کارتی (پیکسل)', 'bebanstore')
                )
            ),
            'default' => '4',
            'min' => '0',
            'max' => '30',
            'step' => '1',
            'dependency' => array('display_style', '==', 'card')
        ),
        'label_gap' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => __('فاصله عمودی عدد و برچسب', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('فاصله بین عدد و برچسب زیر آن (پیکسل)', 'bebanstore')
                )
            ),
            'default' => '8',
            'min' => '0',
            'max' => '20',
            'step' => '1',
            'dependency' => array('display_style', '==', 'card')
        )
    ),
    'help' => array(
        'title' => __('راهنمای شمارنده معکوس', 'bebanstore'),
        'content' => __('این ویژگی شمارنده معکوس زیبا و کاربرپسند را برای محصولات دارای تخفیف یا زمان محدود نمایش می‌دهد. شمارنده معکوس به صورت خودکار روی تمام محصولاتی که دارای تاریخ انقضای تخفیف یا زمان محدود هستند فعال می‌شود و تا زمان انقضا به صورت زنده شمارش معکوس انجام می‌دهد. <strong>تنظیمات محصولات متغیر:</strong> برای محصولات متغیر که دارای چندین گزینه هستند، می‌توانید نحوه انتخاب زمان شمارنده را تعیین کنید. گزینه "متغیرهای پیشفرض" از زمان متغیر پیشفرض ووکامرس استفاده می‌کند، "کمترین زمان" کوتاه‌ترین زمان باقی‌مانده را انتخاب می‌کند، و "طولانی‌ترین زمان" بیشترین زمان باقی‌مانده را نمایش می‌دهد. در صورت عدم وجود متغیر پیشفرض، سیستم به صورت خودکار به حالت "کمترین زمان" تغییر می‌کند. <strong>سبک‌های نمایش:</strong> سه سبک مختلف برای نمایش شمارنده در دسترس است: "کلاسیک" بدون برچسب و با نقطه جداکننده، "کارتی" با برچسب در کادرهای جداگانه، و "خطی" با برچسب در یک خط. می‌توانید متن هر برچسب را به صورت سفارشی تنظیم کنید تا با زبان و استایل فروشگاه شما هماهنگ باشد.', 'bebanstore')
    )
); 