<?php
/**
 * Quantity Control Feature Settings
 * 
 * @package BebanStore
 * @since 1.0.0
 */

return array(
    'id' => 'custom_quantity_control',
    'name' => __('دکمه‌های افزایش/کاهش محصول', 'bebanstore'),
    'description' => __('نمایش دکمه‌های + و - به جای فیلد عددی برای تغییر تعداد محصول', 'bebanstore'),
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تنظیمات اصلی
        'main_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات اصلی', 'bebanstore'),
            'description' => __('تنظیمات اولیه دکمه‌های افزایش و کاهش', 'bebanstore')
        ),
        'quantity_style' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => __('استایل کنترل تعداد', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('انتخاب استایل نمایش کنترل تعداد (در حال حاضر فقط استایل ۱ فعال است)', 'bebanstore')
                )
            ),
            'default' => 'style1',
            'options' => array(
                'style1' => __('استایل ۱', 'bebanstore')
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'enable_trash_button' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('فعال کردن دکمه سطل زباله', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این گزینه باعث می‌شود که وقتی تعداد محصول به 1 می‌رسد، دکمه منفی به آیکون سطل زباله تبدیل شود تا کاربر بتواند محصول را از سبد خرید حذف کند.', 'bebanstore')
                ),
                array(
                    'type' => 'warning',
                    'text' => __('هشدار: اگر این ویژگی را فعال می‌کنید، حتماً پاپ‌آپ حذف محصول را از تب سبد خرید غیرفعال کنید تا از تداخل جلوگیری شود.', 'bebanstore')
                )
            ),
            'default' => false
        ),
        
        'remove_default_remove_button' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('مخفی کردن دکمه حذف پیشفرض', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال‌سازی این گزینه، دکمه حذف پیش‌فرض ووکامرس از سبد خرید مخفی می‌شود و فقط دکمه سطل زباله کنترل تعداد کار می‌کند', 'bebanstore')
                )
            ),
            'default' => false
        ),
        
        // گروه تنظیمات پاپ‌آپ تأیید حذف
        'confirmation_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات پاپ‌آپ تأیید حذف', 'bebanstore'),
            'description' => __('تنظیمات مربوط به پنجره تأیید حذف محصول', 'bebanstore')
        ),
        'enable_remove_confirmation' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('تایید حذف', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('نمایش پنجره تایید قبل از حذف محصول با دکمه سطل زباله', 'bebanstore')
                )
            ),
            'default' => false
        ),
        
        // ========== تب استایل ==========
        
        // گروه رنگ‌های مودال
        'modal_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌های مودال تأیید', 'bebanstore'),
            'description' => __('رنگ‌های پنجره تأیید حذف محصول را تنظیم کنید', 'bebanstore')
        ),
        'modal_background_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه مودال', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه پنجره تأیید حذف محصول', 'bebanstore')
                )
            ),
            'default' => '#ffffff',
            'status' => 'active'
        ),
        'modal_title_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ عنوان مودال', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن عنوان پنجره تأیید حذف', 'bebanstore')
                )
            ),
            'default' => '#000000',
            'status' => 'active'
        ),
        'modal_description_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن توضیحات', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن توضیحات در پنجره تأیید حذف', 'bebanstore')
                )
            ),
            'default' => '#666666',
            'status' => 'active'
        ),
        
        // گروه رنگ‌های دکمه‌های تأیید
        'buttons_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌های دکمه‌های تأیید', 'bebanstore'),
            'description' => __('رنگ‌های دکمه‌های تأیید و انصراف را تنظیم کنید', 'bebanstore')
        ),
        'confirm_button_bg_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه دکمه تایید', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه دکمه تأیید حذف محصول', 'bebanstore')
                )
            ),
            'default' => '#dc3545',
            'status' => 'active'
        ),
        'confirm_button_text_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن دکمه تایید', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن دکمه تأیید حذف محصول', 'bebanstore')
                )
            ),
            'default' => '#ffffff',
            'status' => 'active'
        ),
        'cancel_button_bg_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه دکمه انصراف', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه دکمه انصراف از حذف محصول', 'bebanstore')
                )
            ),
            'default' => '#ffffff',
            'status' => 'active'
        ),
        'cancel_button_text_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن دکمه انصراف', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن دکمه انصراف از حذف محصول', 'bebanstore')
                )
            ),
            'default' => '#007bff',
            'status' => 'active'
        )
    ),
    'help' => array(
        'title' => __('راهنمای دکمه‌های افزایش/کاهش محصول', 'bebanstore'),
        'content' => __('این ویژگی فیلد عددی ساده را با دکمه‌های کاربرپسند + و - جایگزین می‌کند تا مشتریان بتوانند به راحتی تعداد محصول مورد نظر خود را تغییر دهند. این دکمه‌ها در تمام صفحات ووکامرس از جمله صفحه محصول، سبد خرید و تسویه حساب به صورت یکپارچه کار می‌کنند. زمانی که تعداد محصول به ۱ برسد و گزینه "فعال کردن دکمه سطل زباله" را فعال کرده باشید، دکمه منفی به صورت خودکار به آیکون سطل زباله تبدیل می‌شود تا مشتری بتواند با یک کلیک محصول را از سبد خرید حذف کند. در صورتی که این گزینه را غیرفعال کنید، دکمه منفی در تعداد ۱ به صورت غیرفعال نمایش داده می‌شود تا از حذف تصادفی محصول جلوگیری شود.', 'bebanstore')
    ),
    'warning' => array(
        'title' => __('هشدار مهم', 'bebanstore'),
        'content' => __('این ویژگی دارای سیستم پاپ‌آپ تأیید حذف محصول داخلی و اختصاصی خود است. بنابراین اگر قصد استفاده از این ویژگی را دارید، نیازی به فعال‌سازی ویژگی "پاپ‌آپ تأیید حذف محصول" از تب سبد خرید نیست و حتی توصیه می‌شود آن را غیرفعال کنید تا از تداخل عملکرد دو ویژگی و ایجاد تجربه کاربری نامطلوب جلوگیری شود.', 'bebanstore')
    ),
    'pro_features' => array(
        'title' => __('ویژگی‌های پیشرفته در نسخه پرو', 'bebanstore'),
        'features' => array(
            __('انتخاب استایل‌های مختلف برای دکمه‌ها (دایره‌ای، مربعی، مدرن)', 'bebanstore'),
            __('تنظیم اندازه و فاصله دکمه‌ها', 'bebanstore'),
            __('افکت‌های انیمیشن هنگام کلیک', 'bebanstore'),
            __('نمایش شماره تعداد به صورت متحرک', 'bebanstore'),
            __('امکان تنظیم محدودیت تعداد برای هر محصول', 'bebanstore'),
            __('پیام‌های سفارشی برای حداکثر و حداقل تعداد', 'bebanstore')
        )
    )
); 