<?php
/**
 * Express Shipping Feature Settings
 * 
 * @package BebanStore
 * @since 1.0.0
 */

return array(
    'id' => 'express_shipping',
    'name' => 'ارسال سریع',
    'description' => 'نمایش نشان ارسال سریع برای محصولاتی که امکان ارسال سریع دارند',
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تنظیمات اصلی
        'main_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات اصلی', 'bebanstore'),
            'description' => __('تنظیمات اولیه نشان ارسال سریع', 'bebanstore')
        ),
        'express_shipping_badge_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('متن نشان ارسال سریع', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('متن نمایشی که روی نشان ارسال سریع نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'ارسال سریع',
            'required' => true
        ),
        
        // گروه تنظیمات نمایش
        'display_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات نمایش', 'bebanstore'),
            'description' => __('محل و نحوه نمایش نشان ارسال سریع را تنظیم کنید', 'bebanstore')
        ),
        'express_shipping_show_in_cart' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('نمایش در سبد خرید', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، نشان ارسال سریع در صفحه سبد خرید نیز نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => false
        ),
        'express_shipping_show_tooltip' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('تولتیپ', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، هنگام هاور روی نشان ارسال سریع، یک تولتیپ با توضیحات اضافی نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => true
        ),
        'express_shipping_tooltip_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('متن تولتیپ', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('متن توضیحی که هنگام هاور روی نشان ارسال سریع نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'ارسال سریع به تهران',
            'required' => true
        ),
        
        // ========== تب استایل ==========
        
        // گروه رنگ‌های نشان
        'badge_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌های نشان', 'bebanstore'),
            'description' => __('رنگ‌های نشان ارسال سریع را تنظیم کنید', 'bebanstore')
        ),
        'express_shipping_badge_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه نشان', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه نشان ارسال سریع', 'bebanstore')
                )
            ),
            'default' => '#FF661F'
        ),
        'express_shipping_badge_text_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن نشان', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن نشان ارسال سریع', 'bebanstore')
                )
            ),
            'default' => '#ffffff'
        )

    )
); 