<?php
/**
 * Product Discount Settings
 * 
 * @package BebanStore
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'product_discount',
    'name' => 'درصد تخفیف محصول',
    'description' => 'نمایش درصد تخفیف محصول به صورت شورت‌کد',
    'has_settings' => true,
    'has_pro_settings' => true,
    'has_pro_elementor' => true,
    'elementor_widget' => array(
        'widget_file' => 'product-discount-elementor.php',
        'widget_class' => 'Product_Discount_Elementor_Widget',
        'widget_name' => 'bebanstore_product_discount',
        'title' => __('المان المنتور درصد تخفیف', 'bebanstore'),
        'description' => __('از این المان در ویرایشگر المنتور استفاده کنید تا درصد تخفیف محصول را نمایش دهید.', 'bebanstore')
    ),
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تنظیمات نمایش
        'display_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات نمایش', 'bebanstore'),
            'description' => __('تنظیمات نمایش درصد تخفیف محصولات', 'bebanstore')
        ),
        'show_out_of_stock_discount' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('تخفیف محصولات ناموجود', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، درصد تخفیف برای محصولات اتمام یافته نیز نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => false
        ),
        'show_discount_next_to_price_simple' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('نمایش تخفیف کنار قیمت (محصولات عادی)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، درصد تخفیف به صورت خودکار کنار قیمت محصولات عادی نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => false
        ),
        'show_discount_next_to_price_variable' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('نمایش تخفیف کنار قیمت (محصولات متغیر)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، درصد تخفیف به صورت خودکار کنار قیمت محصولات متغیر نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => false
        ),
        
        // ========== تب استایل ==========
        
        // گروه رنگ‌بندی
        'colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌بندی', 'bebanstore'),
            'description' => __('رنگ‌های نمایش درصد تخفیف را تنظیم کنید', 'bebanstore')
        ),
        'background_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه نمایش درصد تخفیف محصول', 'bebanstore')
                )
            ),
            'default' => '#ff4444'
        ),
        'text_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن درصد تخفیف محصول', 'bebanstore')
                )
            ),
            'default' => '#ffffff'
        )
    )
); 