<?php
/**
 * Tracking Code feature settings
 * 
 * @package BebanStore
 * @since 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'tracking_code',
    'name' => 'کد رهگیری پستی',
    'description' => 'نمایش کد رهگیری پستی در صفحه جزئیات سفارش',
    'help' => array(
        'title' => 'راهنمای استفاده از کد رهگیری',
        'content' => 'با فعال‌سازی این ویژگی، یک فیلد ورودی کد رهگیری به سفارشات ووکامرس اضافه می‌شود که به شما امکان می‌دهد کد رهگیری مرسولات پستی را برای هر سفارش ثبت کنید. این کد رهگیری به صورت خودکار در صفحه حساب کاربری مشتری و همچنین در بخش جزئیات سفارش نمایش داده می‌شود تا مشتریان بتوانند به راحتی وضعیت ارسال مرسوله خود را از طریق سامانه‌های پستی پیگیری کنند. در صورتی که پس از فعال‌سازی این ویژگی، فیلد کد رهگیری در صفحه ویرایش سفارشات ووکامرس نمایش داده نشد، لطفاً وارد مسیر <strong>پیشخوان > ووکامرس > پیکربندی > تب پیشرفته > تب امکانات</strong> شوید و گزینه <strong>"ذخیره‌سازی نوشته‌های وردپرس (قدیمی)"</strong> را فعال کنید تا مشکل برطرف شود.'
    ),
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه متن‌های رابط کاربری
        'ui_texts_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('متن‌های رابط کاربری', 'bebanstore'),
            'description' => __('متن‌های نمایش داده شده به کاربران را تنظیم کنید', 'bebanstore')
        ),
        'info_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('متن راهنمای رهگیری', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('متن راهنمایی که بالای کد رهگیری در صفحه جزئیات سفارش نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'با استفاده از سامانه رهگیری پست می‌توانید از وضعیت مرسوله باخبر شوید.',
            'required' => true
        ),
        'tracking_link_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('متن لینک رهگیری', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('متن دکمه لینک که کاربر را به سامانه رهگیری هدایت می‌کند', 'bebanstore')
                )
            ),
            'default' => 'ورود به سامانه رهگیری',
            'required' => true
        ),
        'code_label' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('برچسب کد رهگیری', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('متن برچسبی که قبل از نمایش کد رهگیری نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'کد رهگیری:',
            'required' => true
        ),
        
        // گروه تنظیمات نمایش
        'display_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات نمایش', 'bebanstore'),
            'description' => __('محل و نحوه نمایش کد رهگیری را تنظیم کنید', 'bebanstore')
        ),
        'display_position' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => __('محل نمایش کد رهگیری', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('محل نمایش باکس کد رهگیری در صفحه جزئیات سفارش را انتخاب کنید', 'bebanstore')
                )
            ),
            'default' => 'before_order_table',
            'options' => array(
                'before_order_table' => 'قبل از جدول سفارش',
                'after_order_table' => 'بعد از جدول سفارش',
                'after_customer_details' => 'بعد از اطلاعات مشتری'
            ),
            'required' => true
        ),
        'show_in_thankyou' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('نمایش در صفحه تشکر', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، کد رهگیری در صفحه تشکر (بعد از تکمیل سفارش) نیز نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => false
        ),
        
        // گروه مراکز پستی
        'postal_centers_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('مراکز پستی', 'bebanstore'),
            'description' => __('مراکز پستی که می‌خواهید در لیست رهگیری نمایش داده شوند را انتخاب کنید', 'bebanstore')
        ),
        'postal_center_post_ir' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('اداره پست', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، لینک رهگیری اداره پست ایران در لیست مراکز پستی نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => true
        ),
        'postal_center_tipax' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('تیپاکس', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، لینک رهگیری تیپاکس در لیست مراکز پستی نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => false
        ),
        'postal_center_deka_post' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('دکا پست', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، لینک رهگیری دکا پست در لیست مراکز پستی نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => false
        ),
        'postal_center_custom' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('سایر مراکز پستی', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، لینک‌های مراکز پستی دیگر در لیست رهگیری نمایش داده می‌شوند', 'bebanstore')
                )
            ),
            'default' => false
        ),
        
        // گروه تنظیمات نوع ارسال
        'delivery_type_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات نوع ارسال', 'bebanstore'),
            'description' => __('نحوه نمایش نام شرکت پستی را تنظیم کنید', 'bebanstore')
        ),
        'show_delivery_type' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => __('نمایش نوع ارسال', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، نام شرکت پستی (مثل اداره پست، تیپاکس) در کنار کد رهگیری نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => true
        ),
        'delivery_type_position' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => __('محل نمایش نوع ارسال', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('نحوه نمایش نام شرکت پستی را انتخاب کنید: به صورت برچسب جداگانه یا درون متن لینک رهگیری', 'bebanstore')
                )
            ),
            'default' => 'separate_label',
            'options' => array(
                'separate_label' => __('برچسب جداگانه', 'bebanstore'),
                'in_link_text' => __('در متن لینک رهگیری', 'bebanstore')
            ),
            'required' => true
        ),
        
        // ========== تب استایل ==========
        
        // گروه رنگ‌های باکس رهگیری
        'tracking_box_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌های باکس رهگیری', 'bebanstore'),
            'description' => __('رنگ‌های عناصر باکس کد رهگیری را تنظیم کنید', 'bebanstore')
        ),
        'box_bg_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه باکس', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه باکس کد رهگیری در صفحه جزئیات سفارش', 'bebanstore')
                )
            ),
            'default' => '#f8f9fa',
            'required' => true
        ),
        'text_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن توضیحات و راهنما در باکس کد رهگیری', 'bebanstore')
                )
            ),
            'default' => '#212529',
            'required' => true
        ),
        'link_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ لینک', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ لینک‌های رهگیری در باکس کد رهگیری', 'bebanstore')
                )
            ),
            'default' => '#0d6efd',
            'required' => true
        ),
        'code_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ کد رهگیری و آیکون', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ کد رهگیری و آیکون کپی در باکس رهگیری', 'bebanstore')
                )
            ),
            'default' => '#292D32',
            'required' => true
        ),
        
        // گروه رنگ‌های تولتیپ
        'tooltip_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌های تولتیپ', 'bebanstore'),
            'description' => __('رنگ‌های تولتیپ کپی کد رهگیری را تنظیم کنید', 'bebanstore')
        ),
        'tooltip_bg_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه تولتیپ', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه تولتیپ کپی کد رهگیری', 'bebanstore')
                )
            ),
            'default' => '#212529',
            'required' => true
        ),
        'tooltip_text_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن تولتیپ', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن تولتیپ کپی کد رهگیری', 'bebanstore')
                )
            ),
            'default' => '#ffffff',
            'required' => true
        )
    )
); 