<?php
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'wishlist',
    'name' => 'سیستم علاقه‌مندی‌ها',
    'description' => 'افزودن محصولات به لیست علاقه‌مندی‌ها و مدیریت آنها با شورت‌کدهای کاربردی',
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه پیام‌ها
        'messages_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('پیام‌های سیستم', 'bebanstore'),
            'description' => __('متن پیام‌های نمایش داده شده به کاربران را تنظیم کنید', 'bebanstore')
        ),
        'add_to_wishlist_message' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => 'پیام افزودن به علاقه‌مندی‌ها',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'پیامی که پس از افزودن محصول به لیست علاقه‌مندی‌ها نمایش داده می‌شود'
                )
            ),
            'default' => 'محصول به لیست علاقه‌مندی‌ها اضافه شد.',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'remove_from_wishlist_message' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => 'پیام حذف از علاقه‌مندی‌ها',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'پیامی که پس از حذف محصول از لیست علاقه‌مندی‌ها نمایش داده می‌شود'
                )
            ),
            'default' => 'محصول از لیست علاقه‌مندی‌ها حذف شد.',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'already_removed_message' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => 'پیام حذف شده قبلی',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'پیامی که هنگام تلاش برای حذف محصولی که قبلاً حذف شده نمایش داده می‌شود'
                )
            ),
            'default' => 'این محصول قبلاً از لیست علاقه‌مندی‌ها حذف شده است.',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'login_required_message' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => 'پیام نیاز به ورود',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'پیامی که برای کاربران غیر وارد شده هنگام تلاش برای افزودن به علاقه‌مندی‌ها نمایش داده می‌شود'
                )
            ),
            'default' => 'لطفاً ابتدا وارد حساب کاربری خود شوید.',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'empty_wishlist_message' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => 'پیام لیست خالی',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'پیامی که هنگام خالی بودن لیست علاقه‌مندی‌ها نمایش داده می‌شود'
                )
            ),
            'default' => 'لیست علاقه‌مندی‌های شما خالی است.',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'max_wishlist_limit_message' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => 'پیام رسیدن به حد مجاز',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'پیامی که هنگام رسیدن به حداکثر تعداد مجاز محصولات در لیست علاقه‌مندی‌ها نمایش داده می‌شود'
                )
            ),
            'default' => 'شما به حداکثر تعداد مجاز در لیست علاقه‌مندی‌ها رسیده‌اید.',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        
        // گروه تنظیمات حساب کاربری
        'account_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات حساب کاربری', 'bebanstore'),
            'description' => __('مدیریت نحوه نمایش علاقه‌مندی‌ها در حساب کاربری', 'bebanstore')
        ),
        'add_account_tab' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => 'تب علاقه‌مندی‌ها در حساب کاربری',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'با فعال کردن این گزینه، یک تب جدید به صفحه حساب کاربری ووکامرس اضافه می‌شود که لیست علاقه‌مندی‌ها را نمایش می‌دهد'
                )
            ),
            'default' => false,
            'sanitize_callback' => 'rest_sanitize_boolean'
        ),
        'account_tab_title' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => 'عنوان تب علاقه‌مندی‌ها',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'عنوان تب علاقه‌مندی‌ها در صفحه حساب کاربری'
                )
            ),
            'default' => 'علاقه‌مندی‌ها',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'max_wishlist_items' => array(
            'tab' => 'content',
            'type' => 'number',
            'label' => 'حداکثر تعداد محصولات',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'حداکثر تعداد محصولاتی که کاربر می‌تواند اضافه کند (0 = بدون محدودیت)'
                )
            ),
            'default' => 10,
            'min' => 0,
            'max' => 50,
            'sanitize_callback' => 'absint'
        ),
        
        // گروه تنظیمات عمومی
        'general_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات نمایش', 'bebanstore'),
            'description' => __('تنظیمات کلی نحوه عملکرد سیستم علاقه‌مندی‌ها', 'bebanstore')
        ),
        'animation_type' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'نوع انیمیشن دکمه',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'نوع انیمیشن نمایشی هنگام کلیک روی دکمه علاقه‌مندی'
                )
            ),
            'default' => 'dots',
            'options' => array(
                'none' => 'بدون انیمیشن',
                'spinner' => 'اسپینر',
                'dots' => 'نقطه‌ها'
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'wishlist_display_style' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'استایل نمایش محصولات',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'نحوه نمایش محصولات در لیست علاقه‌مندی‌ها را انتخاب کنید'
                )
            ),
            'default' => 'grid',
            'options' => array(
                'grid' => 'استایل 1: نمایش گریدی',
                'list' => 'استایل 2: نمایش کشیده کامل'
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),

        
        // گروه صفحه‌بندی
        'pagination_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات صفحه‌بندی', 'bebanstore'),
            'description' => __('مدیریت نحوه نمایش محصولات در صفحه لیست علاقه‌مندی‌ها', 'bebanstore')
        ),
        'enable_pagination' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => 'صفحه‌بندی',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'با فعال کردن این گزینه، اگر لیست علاقه‌مندی‌ها محصولات زیادی داشته باشد، آن‌ها به صورت صفحه‌بندی‌شده نمایش داده می‌شوند'
                )
            ),
            'default' => false,
            'sanitize_callback' => 'rest_sanitize_boolean'
        ),
        'products_per_page' => array(
            'tab' => 'content',
            'type' => 'number',
            'label' => 'تعداد محصولات در هر صفحه',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'تعداد محصولاتی که در هر صفحه از لیست علاقه‌مندی‌ها نمایش داده می‌شود'
                )
            ),
            'default' => 12,
            'min' => 1,
            'max' => 50,
            'sanitize_callback' => 'absint'
        ),
        'pagination_position' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'موقعیت صفحه‌بندی',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'انتخاب محل نمایش دکمه‌های صفحه‌بندی در لیست علاقه‌مندی‌ها'
                )
            ),
            'default' => 'bottom',
            'options' => array(
                'top' => 'بالا',
                'bottom' => 'پایین',
                'both' => 'بالا و پایین'
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        
        // گروه عملیات گروهی
        'bulk_actions_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('عملیات گروهی', 'bebanstore'),
            'description' => __('امکان حذف همزمان چندین محصول', 'bebanstore')
        ),
        'enable_bulk_actions' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => 'عملیات گروهی',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'با فعال کردن این گزینه، کاربران می‌توانند چندین محصول را همزمان انتخاب و حذف کنند'
                )
            ),
            'default' => false,
            'sanitize_callback' => 'rest_sanitize_boolean'
        ),
        
        // ========== تب استایل ==========
        
        // گروه استایل محتوای محصول
        'product_content_style_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('استایل محتوای محصول', 'bebanstore'),
            'description' => __('تنظیمات ظاهر عنوان و قیمت محصولات در لیست علاقه‌مندی‌ها', 'bebanstore')
        ),
        // عنوان محصول
        'product_title_font_size' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => 'اندازه فونت عنوان محصول (پیکسل)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'اندازه فونت عنوان محصول در باکس‌های لیست'
                )
            ),
            'default' => 14,
            'min' => 10,
            'max' => 24,
            'sanitize_callback' => 'absint'
        ),
        'product_title_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ عنوان محصول',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ متن عنوان محصول'
                )
            ),
            'default' => '#333333',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        // قیمت عادی
        'product_regular_price_font_size' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => 'اندازه فونت قیمت عادی (پیکسل)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'اندازه فونت قیمت عادی (قیمت خط‌خورده)'
                )
            ),
            'default' => 13,
            'min' => 10,
            'max' => 20,
            'sanitize_callback' => 'absint'
        ),
        'product_regular_price_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ قیمت عادی',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ قیمت عادی (قیمت خط‌خورده)'
                )
            ),
            'default' => '#999999',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        // قیمت تخفیف‌خورده
        'product_sale_price_font_size' => array(
            'tab' => 'style',
            'type' => 'number',
            'label' => 'اندازه فونت قیمت تخفیف‌خورده (پیکسل)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'اندازه فونت قیمت فروش (قیمت تخفیف‌خورده)'
                )
            ),
            'default' => 16,
            'min' => 12,
            'max' => 24,
            'sanitize_callback' => 'absint'
        ),
        'product_sale_price_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ قیمت تخفیف‌خورده',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ قیمت فروش (قیمت تخفیف‌خورده)'
                )
            ),
            'default' => '#ef394e',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        
        // گروه استایل دکمه قلب علاقه‌مندی
        'wishlist_btn_style_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('استایل دکمه قلب علاقه‌مندی', 'bebanstore'),
            'description' => __('تنظیمات رنگ Fill و Stroke قلب در سه حالت: عادی، لودینگ و فعال شده', 'bebanstore')
        ),
        // --- حالت عادی (قلب خالی) ---
        'wishlist_btn_normal_fill' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ Fill (حالت عادی - قلب خالی)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ داخل قلب در حالت عادی (معمولاً none یا transparent)'
                )
            ),
            'default' => 'none',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'wishlist_btn_normal_stroke' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ Stroke (حالت عادی - قلب خالی)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ خط دور قلب زمانی که محصول در لیست علاقه‌مندی‌ها نیست'
                )
            ),
            'default' => '#A9ABAD',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        // --- حالت لودینگ ---
        'wishlist_btn_loader_animation_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ انیمیشن (هنگام لودینگ)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ نقطه‌ها یا اسپینر چرخان'
                )
            ),
            'default' => '#292D32',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        // --- حالت فعال (قلب پر) ---
        'wishlist_btn_active_fill' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ Fill (حالت فعال - قلب پر)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ داخل قلب زمانی که محصول در لیست علاقه‌مندی‌ها است'
                )
            ),
            'default' => '#292D32',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'wishlist_btn_active_stroke' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ Stroke (حالت فعال - قلب پر)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ خط دور قلب زمانی که محصول در لیست علاقه‌مندی‌ها است'
                )
            ),
            'default' => '#292D32',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        
        // گروه استایل دکمه افزودن به سبد خرید
        'add_to_cart_style_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('استایل دکمه افزودن به سبد', 'bebanstore'),
            'description' => __('تنظیمات ظاهر دکمه افزودن به سبد خرید در دو حالت عادی و در حال بارگذاری', 'bebanstore')
        ),
        // --- حالت عادی ---
        'add_to_cart_normal_bg' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'پس‌زمینه (حالت عادی)',
            'default' => '#ffffff',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'add_to_cart_normal_text' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ متن (حالت عادی)',
            'default' => '#ef394e',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'add_to_cart_normal_icon' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ آیکون (حالت عادی)',
            'default' => '#ef394e',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'add_to_cart_normal_border' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ کادر (حالت عادی)',
            'default' => '#ef394e',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        // --- حالت لودینگ ---
        'add_to_cart_loader_overlay_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'پس‌زمینه (هنگام لودینگ)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ پس‌زمینه دکمه زمانی که عملیات در حال انجام است'
                )
            ),
            'default' => '#ffffff',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'add_to_cart_loader_animation_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ انیمیشن (هنگام لودینگ)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ نقطه‌ها یا اسپینر چرخان'
                )
            ),
            'default' => '#EF394F',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'add_to_cart_loader_border_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ کادر (هنگام لودینگ)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ کادر دکمه زمانی که عملیات در حال انجام است'
                )
            ),
            'default' => '#ef394e',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        
        // گروه استایل دکمه حذف
        'remove_btn_style_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('استایل دکمه حذف', 'bebanstore'),
            'description' => __('تنظیمات ظاهر دکمه حذف از لیست در دو حالت عادی و در حال بارگذاری', 'bebanstore')
        ),
        // --- حالت عادی ---
        'remove_btn_normal_bg' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'پس‌زمینه (حالت عادی)',
            'default' => '#ffffff',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'remove_btn_normal_icon' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ آیکون (حالت عادی)',
            'default' => '#81858B',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'remove_btn_normal_border' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ کادر (حالت عادی)',
            'default' => '#E0E0E2',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        // --- حالت لودینگ ---
        'remove_loader_overlay_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'پس‌زمینه (هنگام لودینگ)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ پس‌زمینه دکمه زمانی که عملیات حذف در حال انجام است'
                )
            ),
            'default' => '#ffffff',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'remove_loader_animation_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ انیمیشن (هنگام لودینگ)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ نقطه‌ها یا اسپینر چرخان'
                )
            ),
            'default' => '#81858B',
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'remove_loader_border_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ کادر (هنگام لودینگ)',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ کادر دکمه زمانی که عملیات حذف در حال انجام است'
                )
            ),
            'default' => '#E0E0E2',
            'sanitize_callback' => 'sanitize_text_field'
        )
    )
);
