<?php
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'your_savings',
    'name' => 'سود شما از خرید',
    'description' => 'نمایش کل سود و تخفیف کاربر در سبد خرید و صفحه تسویه با قابلیت شخصی‌سازی برچسب و نمایش درصد.',
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تنظیمات محتوا
        'content_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => 'تنظیمات محتوا',
            'description' => 'متن و نحوه نمایش سود کاربر را تنظیم کنید'
        ),
        'savings_label' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => 'برچسب سود شما',
            'default' => 'سود شما از خرید:',
            'required' => true,
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'show_percentage' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => 'درصد سود',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'با فعال کردن این گزینه، درصد سود (نسبت به قیمت اصلی) نیز در کنار مبلغ سود نمایش داده می‌شود'
                )
            ),
            'default' => false,
            'sanitize_callback' => 'rest_sanitize_boolean'
        ),
        
        // گروه محل‌های نمایش
        'display_locations_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => 'محل‌های نمایش',
            'description' => 'مشخص کنید سود کاربر در کدام صفحات نمایش داده شود'
        ),
        'show_in_cart' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => 'نمایش در سبد خرید',
            'default' => false,
            'sanitize_callback' => 'rest_sanitize_boolean'
        ),
        'show_in_checkout' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => 'نمایش در تسویه حساب',
            'default' => false,
            'sanitize_callback' => 'rest_sanitize_boolean'
        ),
        'show_in_order_details' => array(
            'tab' => 'content',
            'type' => 'checkbox',
            'label' => 'نمایش در جزئیات سفارش',
            'default' => false,
            'sanitize_callback' => 'rest_sanitize_boolean'
        ),
        
        // ========== تب استایل ==========
        
        // گروه رنگ‌بندی
        'style_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => 'رنگ‌بندی',
            'description' => 'رنگ نمایش سود را تنظیم کنید'
        ),
        'savings_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ برچسب سود',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ نمایش برچسب "سود شما از خرید"'
                )
            ),
            'default' => '#28a745',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    )
); 