<?php
/**
 * Cart settings tab template
 * 
 * @package BebanStore
 * @since 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get feature settings
$factory = new BebanStore_Feature_Settings_Factory();
$cart_features = array(
    'cart_confirmation',
    'your_savings',
    'save_for_later_cart'
    
);

// Allow Pro features to register for cart tab
$pro_cart_features = apply_filters('bebanstore_pro_cart_features', array());
$cart_features = array_merge($cart_features, $pro_cart_features);

$feature_settings = array();
foreach ($cart_features as $feature_id) {
    $feature_settings[$feature_id] = $factory->get_settings($feature_id);
}

// Get current options
$options = get_option('bebanstore_options', array());
$feature_options = isset($options['feature_settings']) ? $options['feature_settings'] : array();
?>
<div class="bebanstore-cart-settings">
    <div class="bebanstore-section-header">
        <h2><?php _e('تنظیمات سبد خرید', 'bebanstore'); ?></h2>
        <p><?php _e('در این بخش می‌توانید تنظیمات مربوط به سبد خرید را مدیریت کنید.', 'bebanstore'); ?></p>
    </div>
    
    <div class="bebanstore-settings-list">
        <?php if (empty($feature_settings)) : ?>
            <div class="bebanstore-empty-tab">
                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7 18c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zM1 2v2h2l3.6 7.59-1.35 2.45c-.16.28-.25.61-.25.96 0 1.1.9 2 2 2h12v-2H7.42c-.14 0-.25-.11-.25-.25l.03-.12.9-1.63h7.45c.75 0 1.41-.41 1.75-1.03l3.58-6.49c.08-.14.12-.31.12-.48 0-.55-.45-1-1-1H5.21l-.94-2H1zm16 16c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2z"/>
                </svg>
                <h3><?php _e('تنظیمات سبد خرید', 'bebanstore'); ?></h3>
                <p><?php _e('در حال حاضر تنظیماتی برای نمایش وجود ندارد.', 'bebanstore'); ?></p>
            </div>
        <?php else : ?>
            <?php foreach ($feature_settings as $feature_id => $feature_setting) : ?>
                <?php 
                $feature_status = BebanStore_Feature_Status::get_feature_status($feature_id);
                $status_badge = BebanStore_Feature_Status::get_status_badge($feature_status);
                $is_checkbox_enabled = BebanStore_Feature_Status::should_enable_checkbox($feature_id);
                ?>
                <div class="bebanstore-setting-row">
                    <div class="bebanstore-setting-info">
                        <div class="bebanstore-setting-header">
                            <div class="bebanstore-field-wrapper">
                                <?php
                                $feature_status = BebanStore_Feature_Status::get_feature_status($feature_id);
                                
                                if (BebanStore_Feature_Status::should_enable_checkbox($feature_id)) {
                                    // چک‌باکس فعال برای active و beta
                                    $this->render_checkbox_field($feature_id, '');
                                    
                                    // نمایش دکمه تنظیمات در کنار چک‌باکس
                                    if (BebanStore_Feature_Status::should_show_settings_button($feature_id)) {
                                        $this->render_additional_settings_button($feature_id, $feature_settings, $options);
                                    }
                                    
                                    // نمایش badge ویژگی (Pro یا Freemium)
                                    $this->render_feature_badges($feature_id, $feature_setting);
                                } else {
                                    // فقط badge برای سایر وضعیت‌ها
                                    echo BebanStore_Feature_Status::get_status_badge($feature_status);
                                }
                                ?>
                            </div>
                            <h3 class="bebanstore-setting-title">
                                <?php echo esc_html($feature_setting['name']); ?>
                                <?php 
                                // نمایش badge وضعیت در کنار عنوان فقط برای active و beta (ولی نه برای ویژگی‌های پرو)
                                if (BebanStore_Feature_Status::should_enable_checkbox($feature_id)) {
                                    // badge وضعیت را فقط برای non-pro features نمایش بده
                                    if (!isset($feature_setting['is_pro_feature']) || !$feature_setting['is_pro_feature']) {
                                        echo $status_badge;
                                    }
                                }
                                ?>
                            </h3>
                        </div>
                        <p class="bebanstore-setting-description"><?php echo esc_html($feature_setting['description']); ?></p>
                        <div class="bebanstore-setting-control">
                            <div class="bebanstore-setting-subsettings" data-feature="<?php echo esc_attr($feature_id); ?>" style="display: none;">
                                <?php 
                                // بررسی اینکه آیا ویژگی shortcode یا help دارد (حتی اگر settings خالی باشد)
                                $has_shortcode_in_settings = isset($feature_settings[$feature_id]['shortcode']) && !empty($feature_settings[$feature_id]['shortcode']);
                                $has_help_in_settings = isset($feature_settings[$feature_id]['help']) && !empty($feature_settings[$feature_id]['help']);
                                $has_warning_in_settings = isset($feature_settings[$feature_id]['warning']) && !empty($feature_settings[$feature_id]['warning']);
                                $has_pro_elementor_in_settings = isset($feature_settings[$feature_id]['has_pro_elementor']) && $feature_settings[$feature_id]['has_pro_elementor'];
                                
                                // اگر has_settings true است یا shortcode/help دارد، render_tabbed_settings را فراخوانی کن
                                if ((isset($feature_settings[$feature_id]['has_settings']) && $feature_settings[$feature_id]['has_settings']) || 
                                    $has_shortcode_in_settings || 
                                    $has_help_in_settings || 
                                    $has_warning_in_settings || 
                                    $has_pro_elementor_in_settings) {
                                    $this->render_tabbed_settings($feature_id, $feature_settings[$feature_id], $feature_options);
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div> 