<?php
/**
 * Thank you settings tab template
 * 
 * @package BebanStore
 * @since 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get feature settings
$factory = new BebanStore_Feature_Settings_Factory();
$thank_you_features = array();

// Allow Pro features to register for thank you tab
$pro_thank_you_features = apply_filters('bebanstore_pro_thank_you_features', array());
$thank_you_features = array_merge($thank_you_features, $pro_thank_you_features);

$feature_settings = array();
foreach ($thank_you_features as $feature_id) {
    $feature_settings[$feature_id] = $factory->get_settings($feature_id);
}

// Get current options
$options = get_option('bebanstore_options', array());
$feature_options = isset($options['feature_settings']) ? $options['feature_settings'] : array();
?>
<div class="bebanstore-thank-you-settings">
    <div class="bebanstore-section-header">
        <h2><?php _e('تنظیمات صفحه تشکر', 'bebanstore'); ?></h2>
        <p><?php _e('در این بخش می‌توانید تنظیمات مربوط به صفحه تشکر را مدیریت کنید.', 'bebanstore'); ?></p>
    </div>
    
    <div class="bebanstore-settings-list">
        <?php if (empty($feature_settings)) : ?>
            <div class="bebanstore-empty-tab">
                <h3><?php _e('تنظیمات صفحه تشکر', 'bebanstore'); ?></h3>
                <p><?php _e('در حال حاضر تنظیماتی برای نمایش وجود ندارد.', 'bebanstore'); ?></p>
            </div>
        <?php endif; ?>
    </div>
</div> 