jQuery(document).ready(function($) {
    'use strict';

    // Get current tab from URL
    function getCurrentTab() {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get('tab') || 'general';
    }

    // Initialize active tab - only if we're on bebanstore settings page
    if (window.location.search.includes('page=bebanstore-settings')) {
        const initialTab = getCurrentTab();
        $(`.bebanstore-tabs .nav-tab[href*="tab=${initialTab}"]`).addClass('nav-tab-active');
        $('.bebanstore-tab-pane[data-tab="' + initialTab + '"]').show();
        $('#bebanstore-settings-form').addClass('active-tab-' + initialTab);
    }

    // Handle tab switching - only for bebanstore tabs
    $('.bebanstore-tabs .nav-tab').on('click', function(e) {
        e.preventDefault();
        var tab = $(this).attr('href').split('tab=')[1];
        
        // Only proceed if this is a bebanstore tab
        if (!tab || !$(this).closest('.bebanstore-tabs').length) {
            return;
        }
        
        // Update active tab
        $('.bebanstore-tabs .nav-tab').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');
        
        // Update hidden input
        $('input[name="bebanstore_active_tab"]').val(tab);
        
        // Show/hide tab content
        $('.bebanstore-tab-pane').hide();
        $('.bebanstore-tab-pane[data-tab="' + tab + '"]').show();
        
        // Update form class
        $('#bebanstore-settings-form').removeClass(function(index, className) {
            return (className.match(/(^|\s)active-tab-\S+/g) || []).join(' ');
        }).addClass('active-tab-' + tab);
        
        // Update URL without reloading - only if we're on bebanstore settings page
        if (window.location.search.includes('page=bebanstore-settings')) {
            var newUrl = window.location.pathname + '?page=bebanstore-settings&tab=' + tab;
            window.history.pushState({}, '', newUrl);
        }
    });

    // Fix: keep user on the same tab after saving settings
    $('#bebanstore-settings-form').on('submit', function() {
        // Only update referer if we're on bebanstore settings page
        if (window.location.search.includes('page=bebanstore-settings')) {
            var currentUrl = window.location.pathname + window.location.search;
            $(this).find('input[name="_wp_http_referer"]').val(currentUrl);
        }
    });

    // Check and disable settings buttons that have no settings
    // دیگه نیاز به چک کردن دکمه‌های تنظیمات نیست
    // چون همیشه حداقل تب پیشرفته و شورتکد وجود دارد
    // function checkSettingsButtons() {
    //     $('.bebanstore-setting-subsettings').each(function() {
    //         var $subsettings = $(this);
    //         var $button = $subsettings.closest('.bebanstore-setting-control').find('.bebanstore-show-settings');
    //         
    //         // If there are no settings fields, disable the button
    //         if ($subsettings.find('.bebanstore-flelds-subsettings').length === 0) {
    //             $button.addClass('disabled');
    //         }
    //     });
    // }

    // // Run check on page load
    // checkSettingsButtons();

    // Initialize tooltips
    function initTooltips() {
        $('.bebanstore-tooltip-icon').each(function() {
            var $icon = $(this);
            var tooltipText = $icon.data('tooltip');
            
            if (tooltipText) {
                $icon.append('<div class="bebanstore-tooltip">' + tooltipText + '</div>');
            }
        });
    }

    // Initialize tooltips on page load
    initTooltips();

    // نمایش/مخفی کردن تنظیمات اضافی
    $('.bebanstore-show-settings').on('click', function() {
        var $button = $(this);
        // جستجو در setting-row برای پیدا کردن subsettings
        var $subsettings = $button.closest('.bebanstore-setting-row').find('.bebanstore-setting-subsettings');
        
        // اگر دکمه غیرفعال است، کاری نکن
        if ($button.hasClass('disabled')) {
            return;
        }
        
        // نمایش/مخفی کردن تنظیمات
        if ($subsettings.is(':visible')) {
            $subsettings.slideUp();
        } else {
            $subsettings.slideDown();
        }
    });

    // Function to update shortcode button visibility
    // function updateShortcodeButton() {
    //     var $salesProgressCheckbox = $('input[name="bebanstore_options[sales_progress]"]');
    //     var $countdownCheckbox = $('input[name="bebanstore_options[countdown]"]');
    //     var $expressShippingCheckbox = $('input[name="bebanstore_options[express_shipping]"]');
    //     var $productAttributesCheckbox = $('input[name="bebanstore_options[product_attributes]"]');
    //     var $discountBadgesCheckbox = $('input[name="bebanstore_options[discount_badges]"]');
    //     var $productDiscountCheckbox = $('input[name="bebanstore_options[product_discount]"]');
    //     var $orderCountCheckbox = $('input[name="bebanstore_options[order_count]"]');
    //     var $wishlistCheckbox = $('input[name="bebanstore_options[wishlist]"]');
    //     var $customQuantityControlCheckbox = $('input[name="bebanstore_options[custom_quantity_control]"]');
        
    //     var $salesProgressButtonWrapper = $('.bebanstore-shortcode-button-wrapper button[data-feature-id="sales_progress"]').closest('.bebanstore-shortcode-button-wrapper');
    //     var $countdownButtonWrapper = $('.bebanstore-shortcode-button-wrapper button[data-feature-id="countdown"]').closest('.bebanstore-shortcode-button-wrapper');
    //     var $expressShippingButtonWrapper = $('.bebanstore-shortcode-button-wrapper button[data-feature-id="express_shipping"]').closest('.bebanstore-shortcode-button-wrapper');
    //     var $productAttributesButtonWrapper = $('.bebanstore-shortcode-button-wrapper button[data-feature-id="product_attributes"]').closest('.bebanstore-shortcode-button-wrapper');
    //     var $discountBadgesButtonWrapper = $('.bebanstore-shortcode-button-wrapper button[data-shortcode="[beban_discount_badges]"]').closest('.bebanstore-shortcode-button-wrapper');
    //     var $productDiscountButtonWrapper = $('.bebanstore-shortcode-button-wrapper button[data-shortcode="[beban_product_discount_percentage]"]').closest('.bebanstore-shortcode-button-wrapper');
    //     var $orderCountButtonWrapper = $('.bebanstore-shortcode-button-wrapper button[data-feature-id="order_count"]').closest('.bebanstore-shortcode-button-wrapper');
    //     var $wishlistButtonWrapper = $('.bebanstore-shortcode-button-wrapper button[data-feature-id="wishlist"]').closest('.bebanstore-shortcode-button-wrapper');
    //     var $customQuantityControlButtonWrapper = $('.bebanstore-shortcode-button-wrapper button[data-feature-id="custom_quantity_control"]').closest('.bebanstore-shortcode-button-wrapper');
        
    //     // Update visibility based on checkbox state
    //     $salesProgressButtonWrapper.toggle($salesProgressCheckbox.is(':checked'));
    //     $countdownButtonWrapper.toggle($countdownCheckbox.is(':checked'));
    //     $expressShippingButtonWrapper.toggle($expressShippingCheckbox.is(':checked'));
    //     $productAttributesButtonWrapper.toggle($productAttributesCheckbox.is(':checked'));
    //     $discountBadgesButtonWrapper.toggle($discountBadgesCheckbox.is(':checked'));
    //     $productDiscountButtonWrapper.toggle($productDiscountCheckbox.is(':checked'));
    //     $orderCountButtonWrapper.toggle($orderCountCheckbox.is(':checked'));
    //     $wishlistButtonWrapper.toggle($wishlistCheckbox.is(':checked'));
    //     $customQuantityControlButtonWrapper.toggle($customQuantityControlCheckbox.is(':checked'));
    // }
    
    // Only initialize bebanstore functionality if we're on bebanstore settings page
    if (window.location.search.includes('page=bebanstore-settings')) {
        // Initial check for shortcode buttons
        // updateShortcodeButton();
        
        // // Update shortcode buttons on checkbox change
        // $('input[type="checkbox"][name^="bebanstore_options["]').on('change', function() {
        //     updateShortcodeButton();
        // });

        // Show shortcode modal
        $('.bebanstore-show-shortcode').on('click', function(e) {
            e.preventDefault();
            var $button = $(this);
            var title = $button.data('feature-title');
            var shortcode = $button.data('shortcode');
            var description = $button.data('description');

            // Update modal content
            $('.bebanstore-modal-title').text(title);
            $('.bebanstore-shortcode-code').text(shortcode);
            $('.bebanstore-shortcode-description').html(description.replace(/\n/g, '<br>'));

            // Show modal
            $('#bebanstore-shortcode-modal').addClass('active');
        });

        // Close modal
        $('.bebanstore-modal-close, .bebanstore-modal-overlay').on('click', function() {
            $('#bebanstore-shortcode-modal').removeClass('active');
        });

        // Copy shortcode
        $('.bebanstore-copy-shortcode').on('click', async function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            var shortcode = $('.bebanstore-shortcode-code').text().trim();
            var $button = $(this);
            
            try {
                // Try using the Clipboard API first
                if (navigator.clipboard && window.isSecureContext) {
                    await navigator.clipboard.writeText(shortcode);
                } else {
                    // Fallback for older browsers
                    var $temp = $('<input>');
                    $('body').append($temp);
                    $temp.val(shortcode).select();
                    document.execCommand('copy');
                    $temp.remove();
                }
                
                // Show success toast
                if (typeof BebanStoreToast !== 'undefined') {
                    BebanStoreToast.success('شورت‌کد با موفقیت کپی شد');
                }
                
                // Show copied message
                var originalText = $button.html();
                $button.html(bebanstoreShortcode.copied);
                
                // Reset button after 2 seconds
                setTimeout(function() {
                    $button.html(originalText);
                }, 2000);
                
            } catch (err) {
                // Show error toast
                if (typeof BebanStoreToast !== 'undefined') {
                    BebanStoreToast.error('خطا در کپی کردن شورت‌کد');
                }
            }
            
            return false;
        });

        // Media Uploader
        var mediaUploader;
        
        $('.bebanstore-media-upload').on('click', function(e) {
            e.preventDefault();
            
            var $button = $(this);
            var $field = $button.data('field');
            var $input = $('input[name="' + $field + '"]');
            var $preview = $button.closest('.bebanstore-media-uploader').find('.bebanstore-media-preview');
            var $removeButton = $button.closest('.bebanstore-media-uploader').find('.bebanstore-media-remove');
            
            // If the uploader object has already been created, reopen the dialog
            if (mediaUploader) {
                mediaUploader.open();
                return;
            }
            
            // Create the media uploader
            mediaUploader = wp.media({
                title: 'انتخاب تصویر',
                button: {
                    text: 'استفاده از تصویر'
                },
                multiple: false
            });
            
            // When an image is selected, run a callback
            mediaUploader.on('select', function() {
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                $input.val(attachment.url);
                $preview.html('<img src="' + attachment.url + '" alt="">');
                $removeButton.show();
            });
            
            // Open the uploader dialog
            mediaUploader.open();
        });
        
        // Remove image
        $('.bebanstore-media-remove').on('click', function(e) {
            e.preventDefault();
            
            var $button = $(this);
            var $field = $button.data('field');
            var $input = $('input[name="' + $field + '"]');
            var $preview = $button.closest('.bebanstore-media-uploader').find('.bebanstore-media-preview');
            
            $input.val('');
            $preview.empty();
            $button.hide();
        });

        // Reset button functionality
        $('.bebanstore-reset-settings').on('click', function(e) {
            e.preventDefault();
            var featureId = $(this).data('feature');
            var subsettings = $('.bebanstore-setting-subsettings[data-feature="' + featureId + '"]');
            
            // Reset all input fields to their default values
            subsettings.find('input, select, textarea').each(function() {
                var defaultValue = $(this).data('default-value');
                if (defaultValue !== undefined) {
                    if ($(this).is(':checkbox')) {
                        $(this).prop('checked', defaultValue === 'true');
                    } else {
                        $(this).val(defaultValue);
                    }
                }
            });
            
            // Show success toast
            if (typeof BebanStoreToast !== 'undefined') {
                BebanStoreToast.success('تنظیمات با موفقیت بازنشانی شد');
            }
        });
    }

    // ========================================
    // Feature Tabbed Settings
    // ========================================
    
    /**
     * Handle clicking on feature settings tabs
     */
    $(document).on('click', '.bebanstore-feature-settings-tab', function(e) {
        e.preventDefault();
        
        var tabId = $(this).data('tab');
        var container = $(this).closest('.bebanstore-feature-tabs-container');
        
        // Remove active class from all tabs and content
        container.find('.bebanstore-feature-settings-tab').removeClass('active');
        container.find('.bebanstore-feature-tab-content').removeClass('active');
        
        // Add active class to clicked tab and its content
        $(this).addClass('active');
        container.find('.bebanstore-feature-tab-content[data-tab="' + tabId + '"]').addClass('active');
    });
    
    /**
     * Initialize first tab as active
     */
    $('.bebanstore-feature-tabs-container').each(function() {
        var firstTab = $(this).find('.bebanstore-feature-settings-tab').first();
        var firstTabId = firstTab.data('tab');
        
        if (firstTabId) {
            firstTab.addClass('active');
            $(this).find('.bebanstore-feature-tab-content[data-tab="' + firstTabId + '"]').addClass('active');
        }
    });
    
    /**
     * Copy shortcode from tab
     */
    $(document).on('click', '.bebanstore-copy-shortcode-tab', async function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var $button = $(this);
        var $codeElement = $button.closest('.bebanstore-shortcode-code-wrapper').find('.bebanstore-shortcode-code-text');
        var shortcode = $codeElement.text().trim();
        
        try {
            // Try using the Clipboard API first
            if (navigator.clipboard && window.isSecureContext) {
                await navigator.clipboard.writeText(shortcode);
            } else {
                // Fallback for older browsers
                var $temp = $('<input>');
                $('body').append($temp);
                $temp.val(shortcode).select();
                document.execCommand('copy');
                $temp.remove();
            }
            
            // Show success toast if available
            if (typeof BebanStoreToast !== 'undefined') {
                BebanStoreToast.success('شورت‌کد با موفقیت کپی شد');
            }
            
            // Update button text temporarily
            var originalHtml = $button.html();
            var originalText = $button.find('span').text();
            
            $button.find('span').text('کپی شد!');
            
            // Reset button after 2 seconds
            setTimeout(function() {
                $button.html(originalHtml);
            }, 2000);
            
        } catch (err) {
            console.error('Error copying shortcode:', err);
            
            // Show error toast if available
            if (typeof BebanStoreToast !== 'undefined') {
                BebanStoreToast.error('خطا در کپی کردن شورت‌کد');
            }
        }
        
        return false;
    });
    
    // ========================================
    // Settings Grouping System - Accordion
    // ========================================
    
    // Accordion Groups
    $(document).on('click', '.bebanstore-accordion-header', function() {
        var $group = $(this).closest('.bebanstore-accordion-group');
        var $container = $group.closest('.bebanstore-flelds-subsettings');
        
        // بستن سایر accordion groups در همان container
        $container.find('.bebanstore-accordion-group').not($group).removeClass('active');
        
        // تغییر وضعیت این accordion
        $group.toggleClass('active');
    });
    
    // Section Accordion Headers
    $(document).on('click', '.bebanstore-section-accordion-header', function() {
        var $section = $(this).closest('.bebanstore-section-accordion');
        var $container = $section.closest('.bebanstore-flelds-subsettings');
        
        // بستن سایر section accordions در همان container
        $container.find('.bebanstore-section-accordion').not($section).removeClass('active');
        
        // تغییر وضعیت این section
        $section.toggleClass('active');
    });
    
    // ========================================
    // Settings Grouping System - Conditional Fields
    // ========================================
    
    function checkConditionalFields() {
        $('[data-condition]').each(function() {
            var $field = $(this);
            var condition = $field.data('condition');
            
            if (!condition || !condition.field) {
                return;
            }
            
            var $conditionField = $('[name*="[' + condition.field + ']"]');
            var conditionValue = condition.value;
            var currentValue;
            
            if ($conditionField.is(':checkbox')) {
                currentValue = $conditionField.is(':checked');
            } else {
                currentValue = $conditionField.val();
            }
            
            if (currentValue == conditionValue) {
                $field.addClass('condition-met').slideDown(200);
            } else {
                $field.removeClass('condition-met').slideUp(200);
            }
        });
    }
    
    // Check on page load
    if (window.location.search.includes('page=bebanstore-settings')) {
        checkConditionalFields();
        
        // Check on field change
        $(document).on('change', 'input, select, textarea', function() {
            checkConditionalFields();
        });
    }
    
    // ==================== Advanced Tab ====================
    
    // CodeMirror CSS Editor
    var cssEditor = null;
    var isCodeMirrorLoaded = false;
    
    // Load CodeMirror dynamically
    function loadCodeMirror() {
        if (isCodeMirrorLoaded || window.CodeMirror) {
            initCodeMirror();
            return;
        }
        
        // Show loading state immediately
        var $cssEditor = $('#bebanstore_custom_css');
        if ($cssEditor.length) {
            $cssEditor.hide();
            $('.bebanstore-editor-container').append('<div class="bebanstore-editor-loading">در حال بارگذاری ویرایشگر...</div>');
        }
        
        // Load CodeMirror CSS
        var cssLink = document.createElement('link');
        cssLink.rel = 'stylesheet';
        cssLink.href = 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.css';
        cssLink.onload = function() {
            // Load CodeMirror theme
            var themeLink = document.createElement('link');
            themeLink.rel = 'stylesheet';
            themeLink.href = 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/theme/monokai.min.css';
            themeLink.onload = function() {
                // Load CodeMirror JS
                var script = document.createElement('script');
                script.src = 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.js';
                script.onload = function() {
                    // Load CSS mode
                    var cssModeScript = document.createElement('script');
                    cssModeScript.src = 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/css/css.min.js';
                    cssModeScript.onload = function() {
                        isCodeMirrorLoaded = true;
                        initCodeMirror();
                    };
                    cssModeScript.onerror = function() {
                        showFallbackEditor();
                    };
                    document.head.appendChild(cssModeScript);
                };
                script.onerror = function() {
                    showFallbackEditor();
                };
                document.head.appendChild(script);
            };
            themeLink.onerror = function() {
                showFallbackEditor();
            };
            document.head.appendChild(themeLink);
        };
        cssLink.onerror = function() {
            showFallbackEditor();
        };
        document.head.appendChild(cssLink);
    }
    
    // Show fallback editor if CodeMirror fails to load
    function showFallbackEditor() {
        $('.bebanstore-editor-loading').remove();
        var $cssEditor = $('#bebanstore_custom_css');
        if ($cssEditor.length) {
            $cssEditor.show().addClass('bebanstore-fallback-editor');
        }
    }
    
    // Initialize CodeMirror
    function initCodeMirror() {
        var $cssEditor = $('#bebanstore_custom_css');
        if (!$cssEditor.length || cssEditor) return;
        
        cssEditor = CodeMirror.fromTextArea($cssEditor[0], {
            mode: 'css',
            theme: 'monokai',
            lineNumbers: true,
            lineWrapping: true,
            autoCloseBrackets: true,
            matchBrackets: true,
            indentUnit: 4,
            tabSize: 4,
            direction: 'ltr',
            extraKeys: {
                'Ctrl-Space': 'autocomplete'
            }
        });
        
        // Remove loading state and show CodeMirror with smooth transition
        $('.bebanstore-editor-loading').remove();
        $('.CodeMirror').css('opacity', '0').animate({opacity: 1}, 300);
        
        // Update stats
        updateEditorStats();
        cssEditor.on('change', updateEditorStats);
        
        // Editor actions
        $('.bebanstore-editor-btn[data-action="format"]').on('click', function() {
            formatCSS();
        });
        
        $('.bebanstore-editor-btn[data-action="minify"]').on('click', function() {
            minifyCSS();
        });
        
        $('.bebanstore-editor-btn[data-action="unminify"]').on('click', function() {
            unminifyCSS();
        });
        
        
        // CSS Location Selector
        $('#bebanstore_css_location').on('change', function() {
            var location = $(this).val();
            $('.bebanstore-location-hint .hint-text').hide();
            $('.bebanstore-location-hint .hint-text[data-location="' + location + '"]').show();
        });
        
        // Initialize location hint
        var initialLocation = $('#bebanstore_css_location').val();
        $('.bebanstore-location-hint .hint-text').hide();
        $('.bebanstore-location-hint .hint-text[data-location="' + initialLocation + '"]').show();
    }
    
    // Update editor stats
    function updateEditorStats() {
        if (!cssEditor) return;
        
        var content = cssEditor.getValue();
        var lines = content.split('\n').length;
        var chars = content.length;
        
        $('.bebanstore-editor-stats .lines strong').text(lines);
        $('.bebanstore-editor-stats .chars strong').text(chars);
    }
    
    // Format CSS
    function formatCSS() {
        if (!cssEditor) return;
        
        var content = cssEditor.getValue();
        if (!content.trim()) return;
        
        // Simple CSS formatter
        var formatted = content
            .replace(/\s*{\s*/g, ' {\n    ')
            .replace(/;\s*/g, ';\n    ')
            .replace(/\s*}\s*/g, '\n}\n')
            .replace(/\n\s*\n/g, '\n')
            .trim();
        
        cssEditor.setValue(formatted);
        cssEditor.focus();
    }
    
    // Minify CSS
    function minifyCSS() {
        if (!cssEditor) return;
        
        var content = cssEditor.getValue();
        if (!content.trim()) return;
        
        // Simple CSS minifier
        var minified = content
            .replace(/\/\*[\s\S]*?\*\//g, '') // Remove comments
            .replace(/\s+/g, ' ') // Replace multiple spaces with single space
            .replace(/;\s*/g, ';') // Remove spaces after semicolons
            .replace(/{\s*/g, '{') // Remove spaces after opening braces
            .replace(/\s*}/g, '}') // Remove spaces before closing braces
            .replace(/:\s*/g, ':') // Remove spaces after colons
            .replace(/,\s*/g, ',') // Remove spaces after commas
            .trim();
        
        cssEditor.setValue(minified);
        cssEditor.focus();
    }
    
    // Unminify CSS (Beautify)
    function unminifyCSS() {
        if (!cssEditor) return;
        
        var content = cssEditor.getValue();
        if (!content.trim()) return;
        
        // Advanced CSS beautifier
        var beautified = content
            // Add line breaks before selectors
            .replace(/([{};])\s*([.#@][^{;]+)/g, '$1\n$2')
            // Add line breaks before media queries
            .replace(/([{};])\s*(@media[^{]+)/g, '$1\n\n$2')
            // Add line breaks before keyframes
            .replace(/([{};])\s*(@keyframes[^{]+)/g, '$1\n\n$2')
            // Add line breaks before imports
            .replace(/([{};])\s*(@import[^;]+;)/g, '$1\n$2')
            // Add line breaks before font-face
            .replace(/([{};])\s*(@font-face[^{]+)/g, '$1\n\n$2')
            // Format opening braces
            .replace(/\s*{\s*/g, ' {\n    ')
            // Format closing braces
            .replace(/\s*}\s*/g, '\n}\n')
            // Format semicolons
            .replace(/;\s*/g, ';\n    ')
            // Format colons
            .replace(/:\s*/g, ': ')
            // Format commas in selectors
            .replace(/,\s*/g, ',\n')
            // Clean up multiple line breaks
            .replace(/\n\s*\n\s*\n/g, '\n\n')
            // Remove trailing spaces
            .replace(/[ \t]+$/gm, '')
            // Clean up start and end
            .trim();
        
        cssEditor.setValue(beautified);
        cssEditor.focus();
    }
    
    // Load CodeMirror when Advanced tab is visible
    function checkAdvancedTab() {
        var $advancedTab = $('.bebanstore-tab-pane[data-tab="advanced"]');
        if ($advancedTab.is(':visible') && !isCodeMirrorLoaded) {
            loadCodeMirror();
        }
    }
    
    // Check on tab switch
    $('.bebanstore-tabs .nav-tab').on('click', function() {
        setTimeout(checkAdvancedTab, 100);
    });
    
    // Check on page load
    if (window.location.search.includes('page=bebanstore-settings')) {
        setTimeout(checkAdvancedTab, 500);
    }
    
});