jQuery(function($) {
    'use strict';

    var modal = $('#bebanstore-cart-confirmation');
    var confirmBtn = modal.find('.bebanstore-modal-confirm');
    var cancelBtn = modal.find('.bebanstore-modal-cancel');
    var confirmMessage = modal.find('.bebanstore-confirm-message');
    var currentRemoveLink = null;
    var isProcessing = false;
    var isClosing = false;

    // Function to refresh cart fragments
    var refreshCartFragments = {
        url: wc_cart_fragments_params.wc_ajax_url.toString().replace('%%endpoint%%', 'get_refreshed_fragments'),
        type: 'POST',
        success: function(data) {
            if (data && data.fragments) {
                $.each(data.fragments, function(key, value) {
                    $(key).replaceWith(value);
                });
                $(document.body).trigger('wc_fragments_refreshed');
            }
        }
    };

    // Set button text from localized strings
    if (typeof bebanstoreCart !== 'undefined') {
        confirmBtn.text(bebanstoreCart.confirmButton);
        cancelBtn.text(bebanstoreCart.cancelButton);
    }

    // Intercept remove links - only for main cart page, not mini cart
    $(document.body).on('click', '.woocommerce-cart-form .cart_item .product-remove > a, .woocommerce-cart-form .woocommerce-cart-form__cart-item .remove', function(e) {
        e.preventDefault();
        e.stopImmediatePropagation();
        
        if (isClosing) {
            return;
        }
        
        currentRemoveLink = $(this);
        confirmMessage.text(bebanstoreCart.confirmText);
        modal.addClass('show');
    });

    // Handle confirm button click
    confirmBtn.on('click', function() {
        if (isProcessing || !currentRemoveLink || isClosing) {
            return;
        }

        isProcessing = true;
        confirmBtn.addClass('loading');

        var href = currentRemoveLink.attr('href');
        var cartItemKey = '';

        // Try to get cart item key from data attribute first
        if (currentRemoveLink.data('cart_item_key')) {
            cartItemKey = currentRemoveLink.data('cart_item_key');
        }
        // If not found, try to extract from href
        else if (href) {
            var matches = href.match(/remove_item=([^&]+)/);
            if (matches) {
                cartItemKey = decodeURIComponent(matches[1]);
            }
        }

        if (!cartItemKey) {
            showError(bebanstoreCart.errorMessage);
            return;
        }

        var $cartItem = currentRemoveLink.closest('.cart_item, .woocommerce-cart-form__cart-item, .mini_cart_item');

        // Prepare AJAX data
        var ajaxData = {
            action: 'bebanstore_remove_cart_item',
            cart_item_key: cartItemKey,
            nonce: bebanstoreCart.nonce
        };

        $.ajax({
            url: bebanstoreCart.ajaxurl,
            type: 'POST',
            data: ajaxData,
            success: function(response) {
                if (response.fragments) {
                    // First remove the item from DOM with animation
                    $cartItem.fadeOut(300, function() {
                        $(this).remove();

                        // Check if cart is empty
                        var remainingItems = $('.cart_item, .woocommerce-cart-form__cart-item').length;
                        
                        if (remainingItems === 0) {
                            $('.woocommerce-cart-form').replaceWith('<div class="woocommerce"><div class="woocommerce-notices-wrapper"></div><p class="cart-empty woocommerce-info">سبد خرید شما خالی است.</p><p class="return-to-shop"><a class="button wc-backward" href="' + bebanstoreCart.shopUrl + '">بازگشت به فروشگاه</a></p></div>');
                        }
                    });

                    // Update cart totals
                    if ($('.cart_totals').length) {
                        var $cartTotals = $('.cart_totals');
                        
                        // Add loading state if jQuery UI is available
                        if (typeof $.fn.block === 'function') {
                            $cartTotals.block({
                                message: null,
                                overlayCSS: {
                                    background: '#fff',
                                    opacity: 0.6
                                }
                            });
                        } else {
                            $cartTotals.addClass('loading');
                        }

                        $.ajax({
                            url: wc_cart_fragments_params.wc_ajax_url.toString().replace('%%endpoint%%', 'get_cart_totals'),
                            type: 'POST',
                            success: function(response) {
                                $cartTotals.replaceWith(response);
                            },
                            complete: function() {
                                if (typeof $.fn.block === 'function') {
                                    $cartTotals.unblock();
                                } else {
                                    $cartTotals.removeClass('loading');
                                }
                            }
                        });
                    }

                    // Refresh cart fragments
                    $.ajax(refreshCartFragments);
                    
                    // Show success toast notification
                    if (typeof BebanStoreToast !== 'undefined') {
                        BebanStoreToast.warning('محصول از سبد خرید حذف شد');
                    } else {
                        // Fallback to simple alert
                        alert('محصول از سبد خرید حذف شد');
                    }
                    
                    closeModal();
                } else {
                    showError(bebanstoreCart.errorMessage);
                }
            },
            error: function() {
                showError(bebanstoreCart.errorMessage);
            },
            complete: function() {
                isProcessing = false;
                confirmBtn.removeClass('loading');
            }
        });
    });

    // Handle modal close
    function closeModal() {
        if (isClosing) {
            return;
        }
        
        isClosing = true;
        modal.removeClass('show');
        
        setTimeout(function() {
            confirmMessage.text('');
            currentRemoveLink = null;
            isClosing = false;
        }, 300); // Match the CSS transition duration
    }

    // Show error message
    function showError(message) {
        confirmMessage.text(message).addClass('error');
        
        // Show error toast notification
        if (typeof BebanStoreToast !== 'undefined') {
            BebanStoreToast.error(message);
        } else {
            // Fallback to simple alert
            alert(message);
        }
        
        setTimeout(function() {
            confirmMessage.removeClass('error');
        }, 3000);
    }

    // Close modal on cancel button click or outside click
    cancelBtn.on('click', closeModal);
    
    modal.on('click', function(e) {
        if (e.target === this) {
            closeModal();
        }
    });

    // Close modal on escape key
    $(document).on('keyup', function(e) {
        if (e.key === 'Escape' && modal.is(':visible')) {
            closeModal();
        }
    });
}); 