<?php

if (!defined('ABSPATH')) {
    exit;
}

class BebanStore_Product_Attributes extends BebanStore_Shortcode_Feature {
    public function __construct() {
        parent::__construct(
            'product_attributes',
            __('ویژگی‌های محصول', 'bebanstore'),
            __('نمایش ویژگی‌های محصول در قالب گرید', 'bebanstore'),
            'beban_product_attributes',
            __('برای استفاده از این ویژگی شورت‌کد را کپی کنید و در صفحه محصول هر جا که دوست دارید قرار بدید تا ویژگی‌های محصول به صورت گرید نمایش داده شود.', 'bebanstore')
        );

        // Add hooks if feature is enabled
        if ($this->is_enabled()) {
            $this->init_hooks();
        }
    }

    /**
     * Initialize hooks
     */
    private function init_hooks() {
        // Add styles
        add_action('wp_enqueue_scripts', [$this, 'enqueue_assets']);
    }

    /**
     * Enqueue required assets
     */
    public function enqueue_assets() {
        wp_enqueue_style(
            'bebanstore-product-attributes',
            plugin_dir_url(dirname(__FILE__)) . 'assets/css/product-attributes.css',
            array(),
            BEBANSTORE_VERSION
        );
    }

    /**
     * Get feature settings
     */
    public function get_settings() {
        $options = get_option('bebanstore_options', array());
        return isset($options['feature_settings']['product_attributes']) ? $options['feature_settings']['product_attributes'] : array();
    }

    public function get_shortcode_callback() {
        return array($this, 'render_shortcode');
    }

    public function render_shortcode($atts, $content = null) {
        if (!class_exists('WooCommerce')) {
            return '';
        }

        global $product;
        if (!$product || !is_product()) {
            return '';
        }

        $settings = $this->get_settings();
        $attributes = $product->get_attributes();
        
        if (empty($attributes)) {
            return '';
        }

        $output = '<div class="bebanstore-product-attributes">';
        
        $count = 0;
        foreach ($attributes as $attribute) {
            if ($count >= $settings['max_attributes']) {
                break;
            }

            $name = $attribute->get_name();
            $value = $product->get_attribute($name);
            
            if (empty($value)) {
                continue;
            }

            $output .= sprintf(
                '<div class="attribute-item" style="background-color: %s;">
                    <div class="attribute-label" style="color: %s;">%s</div>
                    <div class="attribute-value" style="color: %s;">%s</div>
                </div>',
                esc_attr($settings['background_color']),
                esc_attr($settings['label_color']),
                esc_html(wc_attribute_label($name)),
                esc_attr($settings['text_color']),
                esc_html($value)
            );

            $count++;
        }

        $output .= '</div>';
        return $output;
    }

    /**
     * Cleanup feature resources
     */
    public function cleanup() {
        remove_action('wp_enqueue_scripts', array($this, 'enqueue_assets'));
    }
} 