
// Injects a hidden iframe that loads an admin page that recreats the admin menu cache and reloads the page
function dpppRecreateAdminMenuCacheAndReload() {
    'use strict';
    jQuery( 'body' ).prepend( '<iframe id="dppp-iframe-recreate-cache" style="display:none" onload="dpppReloadPage()" src="' +
        dpppLocalizedRecreate.recreateCacheURL + '" />' );
}

// Injects a hidden iframe that loads an admin page that recreats the network admin menu cache and reloads the page
function dpppRecreateNetworkAdminMenuCacheAndReload() {
    'use strict';
    jQuery( 'body' ).prepend( '<iframe id="dppp-iframe-recreate-cache" style="display:none" onload="dpppReloadPage()" src="' +
        dpppLocalizedRecreate.recreateNetworkCacheURL + '" />' );
}

// Reloads the page
function dpppReloadPage() {
    'use strict';
    window.location.reload( false );
}

// Injects a hidden iframe that loads an admin page that recreats the admin menu cache
function dpppRecreateAdminMenuCache() {
    'use strict';
    if ( jQuery( '#dppp-iframe-recreate-cache' ).length <= 0 ) {
        jQuery( 'body' ).prepend( '<iframe style="display:none" src="' + dpppLocalizedRecreate.recreateCacheURL + '" />' );
    }
}

// Injects a hidden iframe that loads an admin page that recreats the network admin menu cache
function dpppRecreateNetworkAdminMenuCache() {
    'use strict';
    if ( jQuery( '#dppp-iframe-recreate-cache' ).length <= 0 ) {
        jQuery( 'body' ).prepend( '<iframe style="display:none" src="' + dpppLocalizedRecreate.recreateNetworkCacheURL + '" />' );
    }
}

// Half a second after the page loads, we recreate the admin menus cache in an iframe if it is older than 2 hours
jQuery( function() {
    'use strict';
    if ( dpppLocalizedRecreate.cacheAge > dpppLocalizedRecreate.cacheExpireTime ) {
        if ( 1 === parseInt( dpppLocalizedRecreate.isNetworkAdmin ) ) {
            setTimeout( dpppRecreateNetworkAdminMenuCache, 500 );
        } else {
            setTimeout( dpppRecreateAdminMenuCache, 500 );
        }
    }
});
