<?php
/**
 * Plugin Name: YITH WooCommerce Tab Manager Premium
 * Plugin URI: https://yithemes.com/themes/plugins/yith-woocommerce-tab-manager/
 * Description: <strong><code>YITH WooCommerce Tab Manager Premium</code></strong>allows you to add Tabs to products. You can create a global tab or by product or product categories! You can choose from different tab types like editor, faq, contact form, etc. <a href ="https://yithemes.com">Get more plugins for your e-commerce shop on <strong>YITH</strong></a>
 * Version: 2.10.0
 * Author: YITH
 * Author URI: https://yithemes.com/
 * Text Domain: yith-woocommerce-tab-manager
 * Domain Path: /abzarwp/languages/
 * WC requires at least: 10.0
 * WC tested up to: 10.2
 * Requires Plugins: woocommerce
 *
 * @author  YITH <plugins@yithemes.com>
 * @package YITH\TabManager
 * @version 2.10.0
 */

/*
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! function_exists( 'yith_ywtm_install_woocommerce_admin_notice' ) ) {
	/**
	 * Show notice if WooCommerce isn't enabled
	 *
	 * @author YITH <plugins@yithemes.com>
	 * @since 1.0.0
	 */
	function yith_ywtm_install_woocommerce_admin_notice() {
		?>
		<div class="error">
			<p><?php esc_html_e( 'YITH WooCommerce Tab Manager is enabled but not effective. It requires WooCommerce in order to work.', 'yith-woocommerce-tab-manager' ); ?></p>
		</div>
		<?php
	}
}

if ( ! function_exists( 'yith_deactivate_plugins' ) ) {
	require_once 'plugin-fw/yit-deactive-plugin.php';
}
yith_deactivate_plugins( 'YWTM_FREE_INIT', plugin_basename( __FILE__ ) );

if ( ! function_exists( 'yith_plugin_onboarding_registration_hook' ) ) {
	include_once 'plugin-upgrade/functions-yith-licence.php';
}
register_activation_hook( __FILE__, 'yith_plugin_onboarding_registration_hook' );

if ( ! defined( 'YWTM_VERSION' ) ) {
	define( 'YWTM_VERSION', '2.10.0' );
}

if ( ! defined( 'YWTM_DB_VERSION' ) ) {
	define( 'YWTM_DB_VERSION', '2.0.2' );
}

if ( ! defined( 'YWTM_PREMIUM' ) ) {
	define( 'YWTM_PREMIUM', '1' );
}

if ( ! defined( 'YWTM_INIT' ) ) {
	define( 'YWTM_INIT', plugin_basename( __FILE__ ) );
}

if ( ! defined( 'YWTM_FILE' ) ) {
	define( 'YWTM_FILE', __FILE__ );
}

if ( ! defined( 'YWTM_DIR' ) ) {
	define( 'YWTM_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'YWTM_URL' ) ) {
	define( 'YWTM_URL', plugins_url( '/', __FILE__ ) );
}

if ( ! defined( 'YWTM_ASSETS_URL' ) ) {
	define( 'YWTM_ASSETS_URL', YWTM_URL . 'assets/' );
}

if ( ! defined( 'YWTM_ASSETS_PATH' ) ) {
	define( 'YWTM_ASSETS_PATH', YWTM_DIR . 'assets/' );
}

if ( ! defined( 'YWTM_TEMPLATE_PATH' ) ) {
	define( 'YWTM_TEMPLATE_PATH', YWTM_DIR . 'templates/' );
}

if ( ! defined( 'YWTM_INC' ) ) {
	define( 'YWTM_INC', YWTM_DIR . 'includes/' );
}

if ( ! defined( 'YWTM_SLUG' ) ) {
	define( 'YWTM_SLUG', 'yith-woocommerce-tab-manager' );
}

if ( ! defined( 'YWTM_SECRET_KEY' ) ) {
	define( 'YWTM_SECRET_KEY', '' );
}

if ( ! function_exists( 'yith_plugin_registration_hook' ) ) {
	require_once 'plugin-fw/yit-plugin-registration-hook.php';
}

register_activation_hook( __FILE__, 'yith_plugin_registration_hook' );

if ( function_exists( 'yith_deactive_jetpack_module' ) ) {
	global $yith_jetpack_1;
	yith_deactive_jetpack_module( $yith_jetpack_1, 'YWTM_PREMIUM', plugin_basename( __FILE__ ) );
}

// Plugin Framework Loader.
if ( file_exists( plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php';
}

if ( ! function_exists( 'YITH_Tab_Manager_Premium_Init' ) ) {

	/* Load YWCM text domain */
	load_plugin_textdomain( 'yith-woocommerce-tab-manager', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

	/**
	 * Unique access to instance of YITH_Tab_Manager class
	 *
	 * @since 1.0.5
	 */
	function YITH_Tab_Manager_Premium_Init() { // phpcs:ignore WordPress.NamingConventions.ValidFunctionName
		// Load required classes and functions.
		require_once YWTM_INC . 'functions.yith-tab-manager-update.php';
		require_once YWTM_INC . 'functions.yith-tab-manager.php';
		require_once YWTM_INC . 'functions.yith-tab-manager-premium.php';
		require_once YWTM_INC . 'class-yith-tab-manager-autoloader.php';
		require_once YWTM_INC . 'class-yith-woocommerce-tab-manager.php';

		global $YIT_Tab_Manager; // phpcs:ignore WordPress.NamingConventions.ValidVariableName
		$YIT_Tab_Manager = yith_tab_manager(); // phpcs:ignore WordPress.NamingConventions.ValidVariableName

		if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
			YITH_Tab_Manager_WPML_Integration::get_instance();
		}
	}
}

add_action( 'yith_wc_tabmanager_premium_init', 'YITH_Tab_Manager_Premium_Init' );

if ( ! function_exists( 'yith_tab_manager_premium_install' ) ) {
	/**
	 * Install tab manager
	 *
	 * @since 1.0.5
	 */
	function yith_tab_manager_premium_install() {

		if ( ! function_exists( 'WC' ) ) {
			add_action( 'admin_notices', 'yith_ywtm_install_woocommerce_admin_notice' );
		} else {
			add_action( 'before_woocommerce_init', 'yith_tab_manager_add_support_hpos_system' );
			do_action( 'yith_wc_tabmanager_premium_init' );
		}
	}
}

add_action( 'plugins_loaded', 'yith_tab_manager_premium_install', 11 );

if ( ! function_exists( 'yith_tab_manager_add_support_hpos_system' ) ) {
	/**
	 * Declare support for HPOS
	 *
	 * @return void
	 */
	function yith_tab_manager_add_support_hpos_system() {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {

			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', YWTM_INIT );
		}
	}
}

/**
 * @author abzarwp
 */
require_once plugin_dir_path( __FILE__ ) . "abzarwp/abzarwp.php";